<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class User_Badge_List extends Model
{
    use HasFactory;

    protected $table = 'tbl_user_badge_list';
    protected $guarded = array();

    protected $casts = [
        'id' => 'integer',
        'user_id' => 'integer',
        'badge_id' => 'integer',
        'coin' => 'integer',
        'status' => 'integer',
    ];

    public function badge()
    {
        return $this->belongsTo(Badge::class, 'badge_id');
    }
}
